% =========================================================================
%   Praktikum MATLAB/Simulink I
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Versuch 2
% Teil 2.1 Grafiken

clear all;
clc;

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 2.1.1 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Zeitvektor
t = linspace(0,5);

% Funktionen
y_1 = 2 - exp(-t) .* cos(2 * pi * t);
y_2 = 1 - exp(-3*t) .* sin(1.7 * pi * t);

% ffnen eines neuen Grafikfensters
figure('name', 'Aufgabenteil 2.1.1')

%Erzeugen der Plots
subplot(3, 1, 1);
plot(t, y_1, 'linewidth', 2)
xlabel('$$t /s$$', 'interpreter', 'latex');
ylabel('$$y_1(t)$$', 'interpreter', 'latex');
title('1. Sprungantwort');
grid on

subplot(3, 1, 2);
plot(t, y_2, 'linewidth', 2)
xlabel('$$t /s$$', 'interpreter', 'latex');
ylabel('$$y_2(t)$$', 'interpreter', 'latex');
title('2. Sprungantwort');
grid on

subplot(3, 1, 3);
plot(t, y_1, 'b', t, y_2, '-.k', 'linewidth', 2)
xlabel('$$t /s$$', 'interpreter', 'latex');
ylabel('$$y_1(t), y_2(t)$$', 'interpreter', 'latex');
legend('y_1(t)','y_2(t)', 'Location', 'NorthEast');
title('Vergleich beider Sprungantworten');
grid on


%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 2.1.2 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Erzeugen eines Einheitskreises
t = (-2*pi:pi/32:2*pi);
x = sin(t);
y = cos(t);
figure('name','Aufgabenteil 2.1.2-Einheitskreis');
plot(x, y, 'linewidth', 2);
ylabel('y')
xlabel('x');
title('Einheitskreis');
grid on


%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Versuchsdurchfhrung 2.1.3 %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Erzeugen einer Einheitskugel
figure('name', 'Aufgabenteil 2.1.3-Einheitskugel');
[p, t]=meshgrid(linspace(-pi, pi, 30), linspace(0, pi, 15));
X = cos(p) .* sin(t);
Y = sin(p) .* sin(t);
Z = cos(t);

surfc(X, Y, Z);
xlabel('x');
ylabel('y');
zlabel('z');
title('Einheitskugel');
